// queue.java
// demonstruje dziaanie kolejki
// uruchomienie programu: C>java QueueApp
////////////////////////////////////////////////////////////////
class Queue
   {
   private int maxSize;
   private long[] queArray;
   private int front;
   private int rear;
   private int nItems;
//--------------------------------------------------------------
   public Queue(int s)          // konstruktor
      {
      maxSize = s;
      queArray = new long[maxSize];
      front = 0;
      rear = -1;
      nItems = 0;
      }
//--------------------------------------------------------------
   public void insert(long j)   // wstawia element na koniec kolejki
      {
      if(rear == maxSize-1)         // zawinicie
         rear = -1;
      queArray[++rear] = j;         // zwikszamy rear i wstawiamy element
      nItems++;                     // przyby jeden element
      }
//--------------------------------------------------------------
   public long remove()         // usuwa element z pocztku kolejki
      {
      long temp = queArray[front++]; // pobieramy element i zwikszamy front
      if(front == maxSize)           // zawinicie
         front = 0;
      nItems--;                      // uby jeden element
      return temp;
      }
//--------------------------------------------------------------
   public long peek()      // podglda element na pocztku kolejki
      {
      return queArray[front];
      }
//--------------------------------------------------------------
   public boolean isEmpty()    // zwraca true, jeeli kolejka pusta
      {
      return (nItems==0);
      }
//--------------------------------------------------------------
   public boolean isFull()     // zwraca true, jeeli kolejka pena
      {
      return (nItems==maxSize);
      }
//--------------------------------------------------------------
   public int size()           // zwraca liczb elementw w kolejce
      {
      return nItems;
      }
//--------------------------------------------------------------
   }  // koniec klasy Queue
////////////////////////////////////////////////////////////////
class QueueApp
   {
   public static void main(String[] args)
      {
      Queue theQueue = new Queue(5);  // kolejka picioelementowa

      theQueue.insert(10);            // wstawiamy 4 elementy
      theQueue.insert(20);
      theQueue.insert(30);
      theQueue.insert(40);

      theQueue.remove();              // usuwamy 3 elementy
      theQueue.remove();              //    (10, 20, 30)
      theQueue.remove();

      theQueue.insert(50);            // wstawiamy 4 dalsze elementy
      theQueue.insert(60);            //    (zawinicie)
      theQueue.insert(70);
      theQueue.insert(80);

      while( !theQueue.isEmpty() )    // usuwamy i wypisujemy...
         {                            // ...wszystkie elementy
         long n = theQueue.remove();  // (40, 50, 60, 70, 80)
         System.out.print(n);
         System.out.print(" ");
         }
      System.out.println("");
      }  // koniec main()
   }  // koniec klasy QueueApp
////////////////////////////////////////////////////////////////
